begin
  require 'faraday'
rescue LoadError
  raise "Faraday needs to be installed before using the AcquiaHttpClient"
end
require 'oj'

Faraday::Request.register_middleware :request_saver => lambda { RspecApiDocumentation::RequestSaver }

module RspecApiDocumentation
  class RequestSaver < Faraday::Middleware
    attr_reader :client

    def initialize(app, client)
      super(app)
      @client = client
    end

    def call(env)
      client.last_request = env

      @app.call(env).on_complete do |env|
        client.last_response = env
      end
    end
  end

  class SpecialHttpClient < ClientBase
    attr_reader :last_response, :last_request
    attr_reader :auth, :user, :pass

    LastRequest = Struct.new(:url, :method, :request_headers, :body)

    def request_headers
      env_to_headers(last_request.request_headers)
    end

    def response_headers
      last_response.response_headers
    end

    def query_string
      last_request.url.query
    end

    def status
      last_response.status
    end

    def response_body

      response_body = last_response.body
      if response_headers['Content-Type'].match(/application\/json/)
        response_body = Oj.load(response_body)
      end

      # $stderr.puts "-" * 80
      # puts response_body
      # $stderr.puts "-" * 80

      response_body

    end

    def request_content_type
      last_request.request_headers["CONTENT_TYPE"]
    end

    def response_content_type
      last_response.request_headers["CONTENT_TYPE"]
    end

    def do_request(method, path, params, request_headers)
      puts "----> Working..."
      http_test_session.send(method, path, params, headers(method, path, params, request_headers))
    end

    def last_request=(env)
      @last_request = LastRequest.new(env.url, env.method, env.request_headers, env.body)
    end

    def last_response=(env)
      @last_response = env
    end

    protected

    def headers(*args)
      headers_to_env(super)
    end

    def handle_multipart_body(request_headers, request_body)
      parsed_parameters = Rack::Request.new({
                                                "CONTENT_TYPE" => request_headers["Content-Type"],
                                                "rack.input" => StringIO.new(request_body)
                                            }).params

      clean_out_uploaded_data(parsed_parameters, request_body)
    end

    def read_request_body
      if [:post, :put].include?(last_request.method)
        last_request.body || ""
      else
        ""
      end
    end

    private

    def clean_out_uploaded_data(params, request_body)
      params.each do |_, value|
        if value.is_a?(Hash)
          if value.has_key?(:tempfile)
            data = value[:tempfile].read
            request_body = request_body.gsub(data, "[uploaded data]")
          else
            request_body = clean_out_uploaded_data(value,request_body)
          end
        end
      end
      request_body
    end


    def http_test_session
      ::Faraday.new(:url => options[:host], :ssl => {:verify => false}, :headers => {'Content-Type' => 'application/json'}) do |faraday|
#        faraday.request :basic_auth, $username, $password
#        faraday.request :url_encoded            # form-encode POST params
        faraday.request :request_saver, self    # save the request and response
        faraday.adapter Faraday.default_adapter # make requests with Net::HTTP
      end
    end
  end
end
