require 'test/unit'

class TestMissingReturn < Test::Unit::TestCase
  class A
    def initialize
      loop { return }
    end
  end

  def test_tp_misses_return_event_when_return_inside_loop_inside_initialize
    events = []

    tracepoint = TracePoint.new(:call, :c_call, :c_return, :return) do |tp|
      events << [ tp.event, tp.method_id]
    end

    tracepoint.enable { A.new }

    expected_events = [ [:c_call, :new],
                        [:call, :initialize],
                        [:c_call, :loop],
                        [:c_return, :loop],
                        [:return, :initialize],
                        [:c_return, :new]
                      ]

    assert_equal expected_events, events
  end
end
