c = Class.new do
  def refined_public; end
  def refined_protected; end
  def refined_private; end

  public :refined_public
  protected :refined_protected
  private :refined_private
end

m = Module.new do
  refine(c) do
    def refined_public; end
    def refined_protected; end
    def refined_private; end

    public :refined_public
    protected :refined_protected
    private :refined_private
  end
end

using m

predicate_methods = %i(
  method_defined?
  public_method_defined?
  protected_method_defined?
  private_method_defined?
)

methods = %i(
  refined_public
  refined_protected
  refined_private
)
predicate_methods.each do |predicate_method|
  puts predicate_method
  puts '-' * 8
  methods.each do |method|
    puts "#{predicate_method}(#{method}) # => #{c.send(predicate_method, method)}"
  end
  puts
end
