c = Class.new
m = Module.new do
  refine(c) do
    def undefined_refined_public; end
    def undefined_refined_protected; end
    def undefined_refined_private; end
    public :undefined_refined_public
    protected :undefined_refined_protected
    private :undefined_refined_private
  end
end

using m

predicate_methods = %i(
  method_defined?
  public_method_defined?
  protected_method_defined?
  private_method_defined?
)

methods = %i(
  undefined_refined_public
  undefined_refined_protected
  undefined_refined_private
)
predicate_methods.each do |predicate_method|
  puts predicate_method
  puts '-' * 8
  methods.each do |method|
    puts "#{predicate_method}(#{method}) # => #{c.send(predicate_method, method)}"
  end
  puts
end
