@mutex = Mutex.new
@count = 0

def stuff
  @mutex.lock
  @count += 1
  print
  @count -= 1
  @mutex.unlock if @count == 0
end

set_trace_func proc { |event, file, line, id, binding, classname|
  info = sprintf("%s %8s %s:%-2d %10s %8s %d", Thread.current, event, file, line, id, classname, @count)
  color = 1 + Thread.current.object_id / 4 % 256
  puts "\e[38;5;#{color}m #{info} \e[39m"
}

1_000.times do
  thread = Thread.new do
    stuff
    sleep
  end
  stuff
  thread.kill
  thread.join
end
