module SimpleInspect
  def inspect
    result = if inspected?
               "#<%s (%d) ...>" % [ inspected_key, inspected_count ]
             else
               super
             end
    inspect!
    "\n" + result
  end

  private
  def inspected?
    inspected[inspected_key].nonzero?
  end

  def inspect!
    inspected[inspected_key] += 1
  end

  def inspected_count
    inspected[inspected_key]
  end

  def inspected
    $__inspected__ ||= Hash.new { |h, k| h[k] = 0 }
  end

  def inspected_key
    "%s:0x%014x" % [ self.class, "0x%014x" % (object_id * 2) ]
  end
end

class Object
  include SimpleInspect
end

class Entity; end
class Indect; end
class Koppler; end
class Occupancy; end
class Control; end
class ScheduleEntry; end
class SQLiteStorage; end
class UBox; end
class USpot; end
class UFlag; end
class UFlow; end
class Sign; end
class CounterGroup; end

obj1    = Indect.new
_, obj2 = Marshal.load(File.read "ruby_object.dump").first

def call_id(obj)
  obj.id
rescue => ex
  ex.message
end

def repeat_call_id(obj, repeats = 100000)
  repeats.times { call_id(obj) }
end

require 'benchmark'

Benchmark.bm(17) do |mark|
  mark.report("Normal #{obj1.class}:") { repeat_call_id(obj1) }
  mark.report("Recursive #{obj2.class}:") { repeat_call_id(obj2) }
end

$__inspected__.clear

p call_id(obj1)
# "undefined method `id' for \n#<Indect:0x007fb2e4029e20>:Indect"
p call_id(obj2)
# "undefined method `id' for #<Indect:0x007fb2e4029c40>"
