class CupsDevice < ActiveRecord::Base
# **************************************************************
  require 'cups'

  
  has_many  :printers
# **************************************************************
#   t.string :cups_name
#   t.string :uuid
#   t.string :info
#   t.string :location
#   t.string :deviceuri
#   t.string :state
#   t.string :statemessage
#   t.string :reason
#   t.string :accepting
#   t.string :shared

#   t.string :capability_ppd
#   t.string :capability_cdd
#   t.string :gcp_uuid
#   t.string :gcp_manufacturer
#   t.string :gcp_model
#   t.string :gcp_setup_url
#   t.string :gcp_support_url
#   t.string :gcp_update_url
#   t.string :gcp_firmware

#   t.boolean :is_default
#   t.boolean :is_defunct
#   t.datetime :statetime

#   t.text :options

#   t.timestamps null: false
# **************************************************************

# **************************************************************
# build_cups_list -- returns list of connected cups devices as objs
# **************************************************************
  def self.build_cups_list( )
    list = Cups.show_destinations  # get list of all printers
    
    return list.map do |cups_name |
      ( (x = CupsDevice.where( cups_name: cups_name ).first ) ?
         x  : build_cups( cups_name )
      )
      end  # map each


  end

# **************************************************************
# get_ppd_filename -- returns nil or ppd filename if present
# **************************************************************
  def self.get_ppd_filename( my_printer )
    list = Dir.glob( File.join( CUPS_PPD_PATH, "*.ppd" ) )
    ptr = File.join( CUPS_PPD_PATH, my_printer ) + ".ppd"
    return ( list.include?( ptr )  ?  ptr : nil )
  end

# **************************************************************
# get_cdd_filename -- returns nil or cdd filename if present
# **************************************************************
  def self.get_cdd_filename( my_printer )
    list = Dir.glob( File.join( CUPS_CDD_PATH, "*.cdd" ) )
    ptr = File.join( CUPS_CDD_PATH, my_printer ) + ".cdd"
    return ( list.include?( ptr )  ?  ptr : nil )
  end

# **************************************************************
# **************************************************************
  def self.build_cups( cups_name )
    ptr_opts = Cups.options_for( cups_name ) 
    
    obj = CupsDevice.new(
        cups_name: cups_name,
        info: ptr_opts["printer-make-and-model"],
        deviceuri: Cups.device_uri_for( cups_name ),
        state: ptr_opts["printer-state"],

        capability_ppd:  get_ppd_filename( cups_name ) || "",
        capability_cdd:  get_cdd_filename( cups_name ) || "",

        gcp_uuid: ptr_opts["printer-type"],
        gcp_manufacturer: ptr_opts["printer-make-and-model"].split(',').first,
        gcp_model: cups_name,
        gcp_setup_url:   GCP_SETUP_URL,
        gcp_support_url: GCP_SUPPORT_URL,
        gcp_update_url:  GCP_UPDATE_URL,
        gcp_firmware: ptr_opts["printer-type"] 

     )

    return obj

  end

# **************************************************************
  def self.testit( cups_name )
       Cups.device_uri_for( cups_name )
#     ptr_opts = Cups.options_for( cups_name ) 
#     
#     CupsDevice.new(
#         cups_name: cups_name,
#         deviceuri: Cups.device_uri_for( cups_name )
#     )
   end
# **************************************************************
# **************************************************************
end
