require 'tk'
require 'tkextlib/tile'
require 'socket'

        $server = TCPServer.open(2000)

$processcodes = %w{ de re hi co cn sp }
$processnames = %w{ defence refresh history command console stop}
# Names of the gifts we can send
$gifts = { 'card' => "required process", 'flowers' => "Flowers", 'nastygram' => "Nastygram" }

# Create and initialize the linked variables we'll need in the interface
$gift = TkVariable.new( "card" )
$names = TkVariable.new ( $processnames )
$sent = TkVariable.new ( "" )
$status = TkVariable.new ( "" )

# Create and grid the outer content frame
root = TkRoot.new
content = Tk::Tile::Frame.new(root) {padding "5 5 12 0"}.grid :column => 0, :row => 0, :sticky => "nwes"
TkGrid.columnconfigure root, 0, :weight => 1
TkGrid.rowconfigure root, 0, :weight => 1

# Create the different widgets; note the variables that many
# of them are bound to, as well as the button callback.
$processes = TkListbox.new(content) {listvariable $names; height 5}
sendlbl = Tk::Tile::Label.new(content) {text "Send to client:"}
send = Tk::Tile::Button.new(content) {text "Send "; command "sendClient"; default "active"}
sentlbl = Tk::Tile::Label.new(content) {textvariable $sent; anchor "center"}
statuslbl = Tk::Tile::Label.new(content) {textvariable $status; anchor "w"}

# Grid all the widgets
$processes.grid :column => 0, :row => 0, :rowspan => 6, :sticky => 'nsew'
sendlbl.grid    :column => 1, :row => 0, :padx => 10, :pady => 5
send.grid       :column => 2, :row => 4, :sticky => 'e'
sentlbl.grid    :column => 1, :row => 5, :columnspan => 2, :sticky => 'n', :pady => 5, :padx => 5
statuslbl.grid  :column => 0, :row => 6, :columnspan => 2, :sticky => 'we'

TkGrid.columnconfigure content, 0, :weight => 1
TkGrid.rowconfigure content, 5, :weight => 1

# Set event bindings for when the selection in the listbox changes,
# when the user double clicks the list, and when they hit the Return key
$processes.bind '<ListboxSelect>', proc{showProcesses}
$processes.bind 'Double-1', Thread.new{sendClient}
root.bind 'Return', Thread.new{sendClient}

# Called when the selection in the listbox changes; figure out
# which process is currently selected, and then lookup its process
# code, and from that, its population.  Update the status message
# with the new population.  As well, clear the message about the
# gift being sent, so it doesn't stick around after we start doing
# other things.
def showProcesses
    idx = $processes.curselection
    if idx.length==1
        idx = idx[0]
        code = $processcodes[idx]
        name = $processnames[idx]
        #popn = $populations[code]
        $status.value = "The ptocess #{name} (#{code}) sent "
    end
    $sent.value = ""
end

# Called when the user double clicks an item in the listbox, presses
# the "Send Gift" button, or presses the Return key.  In case the selected
# item is scrolled out of view, make sure it is visible.
#
# Figure out which country is selected, which gift is selected with the 
# radiobuttons, "send the gift", and provide feedback that it was sent.
def sendClient
    idx = $processes.curselection
    if idx.length==1
        idx = idx[0]    
        $processes.see idx
        name = $processnames[idx]
        client = $server.accept       # Wait for a client to connect
        client.puts name
       # client.close 
                        # Disconnect from the client
        $sent.value = "Sent #{$gifts[$gift.value]} to client process of #{name}"
    end
#$processes.selection_set 0
#showProcesses

end

# Colorize alternating lines of the listbox
0.step($processcodes.length-1, 2) {|i| $processes.itemconfigure i, :background, "#f0f0ff"}
$processes.selection_set 0
showProcesses
# Select the first process in the list; because the <<ListboxSelect>> event is only
# generated when the user makes a change, we explicitly call showProcesses.
Thread.new{Tk.mainloop}


