module SummaryStats
  class AggregateTxService
    class DataHash
      attr_reader :h

      def initialize(&default)
        @h = {}
        @d = default
      end

      def get(*opts)
        assert opts.any?, "At least one opt must be passed"
        x = @h
        opts.each_with_index do |opt, i|
          k = opt.to_s
          unless x.has_key?(k)
            if i < opts.size - 1
              x[k] = {}
            else
              x[k] = @d.call
            end
          end
          x = x[k]
        end
        x
      end

      def set(*opts, &block)
        x = get(*opts)
        yield x
        return self
      end
    end
  end
end
