#!/usr/bin/env ruby

# $ ruby -v
# ruby 2.3.0dev (2015-11-17 trunk 52623) [x86_64-darwin15]
# ruby gc_threads_issue.rb
# stack level too deep
# GC major: 0, minor: 0
# GC major: 0, minor: 0
# GC major: 0, minor: 0
# Killed: 9 # <- gets stuck, so kill -9 is the only way to stop it

# $ ruby -v
# ruby 2.2.3p173 (2015-08-18 revision 51636) [x86_64-darwin14]
#
# $ ruby gc_threads_issue.rb
# stack level too deep
# GC major: 1, minor: 0
# GC major: 1, minor: 0
# GC major: 1, minor: 0
# Killed: 9 # <- gets stuck, so kill -9 is the only way to stop it

# $ ruby -v
# ruby 2.1.5p273 (2014-11-13 revision 48405) [x86_64-darwin14.0]
#
# ruby gc_threads_issue.rb
# stack level too deep
# GC major: 1, minor: 2
# GC major: 14, minor: 14
# GC major: 24, minor: 23
# Killed: 9 # <- gets stuck, so kill -9 is the only way to stop it


# $ ruby -v
# jruby 1.7.13 (1.9.3p392) 2014-06-24 43f133c on Java HotSpot(TM) 64-Bit Server VM 1.8.0_66-b17 [darwin-x86_64]
# Exception in thread "Ruby-0-Thread-1: gc_threads_issue.rb:42" java.lang.ArrayIndexOutOfBoundsException: -1
# GC major: , minor:
# GC major: , minor:
# GC major: , minor:
# GC major: , minor:
# GC major: , minor:
# GC major: , minor:
# GC major: , minor:

class Infinity
  def self.run
    1.times { run }
  end
end

Thread.new do
  loop do
    begin
      Infinity.run
    rescue Exception => e
      puts e.message
    end
    sleep 3
  end
end

Thread.new do
  loop do
    "A" * 1000
  end
end

7.times do
  GC.start
  puts "GC major: #{GC.stat[:major_gc_count]}, minor: #{GC.stat[:minor_gc_count]}"
  sleep 1
end
