require 'erb'

class ERB
  class HTML < ERB
    class HTMLCompiler < Compiler
      class HTMLScanner < Compiler::SimpleScanner
        def stags
          ['<%=='] + super
        end
      end

      def make_scanner(src)
        HTMLScanner.new(src, @trim_mode, @percent)
      end

      def compile_stag(stag, out, scanner)
        case stag
        when '<%=='
          scanner.stag = stag
          add_put_cmd(out, content) if content.size > 0
          self.content = ''
        else
          super
        end
      end

      def compile_content(stag, out)
        case stag
        when '<%=='
          out.push("#{@insert_cmd}(::ERB::Util.html_escape(#{content}))")
        else
          super
        end
      end
    end

    def make_compiler(trim_mode)
      HTMLCompiler.new(trim_mode)
    end
  end
end

# ERB::HTML.new('<%== "<>" %>').result #=> "&lt;&gt;"
