#!/usr/bin/env ruby

require 'set'

recursive_array_1 = [1, 2, 3].tap {|a| a << a}
recursive_array_2 = [1, 2, 3].tap {|a| a << a}
nonrecursive_array_1 = [1, 2, 3]
nonrecursive_array_2 = [1, 2, 3]

recursive_hash_1 = {a: 1, b: 2}.tap {|h| h[:c] = h}
recursive_hash_2 = {a: 1, b: 2}.tap {|h| h[:c] = h}
nonrecursive_hash_1 = {a: 1, b: 2}
nonrecursive_hash_2 = {a: 1, b: 2}

recursive_set_1 = Set.new([1, 2]).tap {|s| s << s}
recursive_set_2 = Set.new([1, 2]).tap {|s| s << s}
nonrecursive_set_1 = Set.new([1, 2])
nonrecursive_set_2 = Set.new([1, 2])

def test(a, b)
  puts "#{a} == #{b}? -> #{a == b}"
end

test(nonrecursive_array_1, nonrecursive_array_2)
test(recursive_array_1, recursive_array_2)

test(nonrecursive_hash_1, nonrecursive_hash_2)
test(recursive_hash_1, recursive_hash_2)

test(nonrecursive_set_1, nonrecursive_set_2)
test(recursive_set_1, recursive_set_2)
