require 'benchmark/ips'
require 'fileutils'

# setup directories
ROOT = /mingw/ =~ RUBY_PLATFORM ? 'v:' : '/tmp'
BASE_DIR = "#{ROOT}/test/myapp/app/views/common"
FileUtils.mkdir_p(BASE_DIR)
%w(_menu_stats.html.erb _menu_stats.en.html.erb).each do |path|
  FileUtils.touch("#{BASE_DIR}/#{path}")
end
20.times do |i|
  FileUtils.touch("#{BASE_DIR}/../#{i}")
  FileUtils.touch("#{BASE_DIR}/#{i}")
end

p BRACES_PATTERN = "#{ROOT}/test/myapp/app/views/common/_menu_stats{.en,}{.html,}{}{.erb,.builder,.raw,.ruby,.jbuilder,.coffee,}"
p RECURSIVE_PATTERN = "#{ROOT}/test/myapp/app/views/**/_menu_stats{.en,}{.html,}{}{.erb,.builder,.raw,.ruby,.jbuilder,.coffee,}"

Benchmark.ips do |x|
  x.report("braces") do
    Dir.glob(BRACES_PATTERN)
  end
  x.report("recursive") do
    Dir.glob(RECURSIVE_PATTERN)
  end
end

# cleanup
FileUtils.rm_rf("#{ROOT}/test")
