# frozen_string_literal: true

require 'fileutils'
require 'benchmark/ips'

# setup directories
ROOT = /mingw/ =~ RUBY_PLATFORM ? 'c:/temp' : '/tmp'
FileUtils.rm_rf("#{ROOT}/test")
BASE_DIR = "#{ROOT}/test/myapp/app/views/common"
FileUtils.mkdir_p(BASE_DIR)
%w(_menu_stats.html.erb _menu_stats.en.html.erb).each do |path|
  FileUtils.touch("#{BASE_DIR}/#{path}")
end
20.times do |i|
  FileUtils.touch("#{BASE_DIR}/../#{i}")
  FileUtils.touch("#{BASE_DIR}/#{i}")
end

LIST_PATTERN = "#{ROOT}/test/myapp/app/views/common/*"
BRACES_PATTERN = "#{ROOT}/test/myapp/app/views/common/_menu_stats{.en,}{.html,}{}{.erb,.builder,.raw,.ruby,.jbuilder,.coffee,}"
RECURSIVE_PATTERN = "#{ROOT}/test/myapp/app/views/**/_menu_stats{.en,}{.html,}{}{.erb,.builder,.raw,.ruby,.jbuilder,.coffee,}"

Benchmark.ips do |x|
  x.report('list') { Dir.glob(LIST_PATTERN) }
  x.report('braces') { Dir.glob(BRACES_PATTERN) }
  x.report('recursive') { Dir.glob(RECURSIVE_PATTERN) }
end
