class Foo
  MyError = Class.new(StandardError)

  def example1
    norf
  rescue MyError => error
    2
  end

  def example2
    norf
  rescue MyError => error
    return 2
  end

  def norf
    raise MyError
  end
end

trace = TracePoint.new(:return) do |tp|
  puts "#{tp.defined_class}##{tp.method_id} RETURNS #{tp.return_value.inspect}"
end

trace.enable

Foo.new.example1 # => 2
puts
Foo.new.example2 # => 2
# >> Foo#norf RETURNS nil
# >> Foo#example1 RETURNS 2
# >> 
# >> Foo#norf RETURNS nil
# >> Foo#example2 RETURNS nil
