#!/bin/sh
rm bug.*.txt
make miniruby

for i in `seq 1 1 999`; do
  ./miniruby bug.rb 2> out.txt
  RESULT=$?
  echo $RESULT >> out.txt
  printf "$i\r"
  if [ "$RESULT" != "0" ]; then
    name=bug.$(printf "%03d" $i)
    if [ -e core.miniruby.* ]; then
      for core in core.miniruby.*; do
        gdb ./miniruby $core -batch -ex "q" >> out.txt
      done
      if grep -q "cfp consist" out.txt; then
        name=$name.cfp
      else
        name=$name.nocfp
      fi
      if grep -q "use prev" out.txt; then
        name=$name.prev
      else
        name=$name.noprev
      fi
    else
      name=$name.nocore
    fi
    if grep -q "BUG" out.txt; then
      name=$name.BUG
    else
      name=$name.silent
    fi
    mv out.txt $name.txt
  fi
  rm -f core.* out.txt
done

