class ActionChooser

  def initialize
    @options = []
  end

  def add(action)
    @options << Option.new(action)
  end

  def choose
    return @options.last.action if @options.size <= 1

    adjust_weights
    @options.last.action
  end

  DEFAULT_WEIGHT = 100
  WEIGHT_CUTOFF = 20

  class Option
    attr_reader :action
    attr_accessor :weight

    def initialize(action, weight = DEFAULT_WEIGHT)
      @action = action
      @weight = weight
    end

    def draw?
      @action.is_a?(Draw)
    end

    def play?
      @action.is_a?(Play)
    end
  end

  private

    def adjust_weights
      if @options.none?(&:play?)
        option_draw = @options.find(&:draw?)
        option_draw&.weight *= 2
      end

      @options.each do |option|
        option.weight = 0 if option.weight < WEIGHT_CUTOFF
      end
    end
end

class Conquer; end

class Draw; end

class Play; end


if __FILE__ == $0
  chooser = ActionChooser.new

  2.times do |age|
    chooser.add(Conquer.new)
  end

  p chooser.choose
end
