module PrintPrototype
  prepend_features ArgumentError

  def to_s
    msg = super.dup

    parameters = receiver.method(method_name).parameters

    human_friendly_parameters = parameters.map do |type, name|
      # type is one of
      # req
      # opt
      # rest
      # key
      # keyreq
      # keyrest
      # block

      human_friendly_type = case type
      when :req
        "required"
      when :opt
        "optional"
      when :rest
        "rest"
      when :key
        "optional keyword"
      when :keyreq
        "required keyword"
      when :keyrest
        "rest keyword"
      when :block
        "block"
      else
        type.to_s
      end

      "\t#{name} (#{human_friendly_type})"
    end

    if human_friendly_parameters.any?
      msg << "\n\nMethod parameters:\n#{human_friendly_parameters.join "\n"}"
    end

  rescue => _e
    puts _e
    super
  end
end
