require 'open3'
require 'net/http'
require 'zip'

Zip.on_exists_proc = true

ROOT_PATH = File.dirname(File.expand_path(__FILE__)).freeze
ENV['PATH'] = "#{ROOT_PATH};#{ENV['PATH']}"

def download_terraform
  uri = URI('https://releases.hashicorp.com/terraform/0.11.1/terraform_0.11.1_windows_amd64.zip')

  Net::HTTP.start(uri.host, uri.port, use_ssl: uri.scheme == 'https') do |http|
    request = Net::HTTP::Get.new(uri)

    http.request(request) do |response|
      open('terraform.zip', 'wb') do |io|
        response.read_body do |chunk|
          io.write(chunk)
        end
      end
    end
  end

  Zip::File.open('terraform.zip') do |zip_file|
    zip_file.each do |entry|
      puts "Extracting #{entry.name}"
      entry.extract(entry.name)
    end
  end
end

download_terraform

def exec(cmd)
  Open3.popen3(cmd) do |stdin, stdout, stderr, thread|
    stdout_thread = Thread.new do
      IO.copy_stream(stdout, STDOUT)
    end

    stderr_thread = Thread.new do
      IO.copy_stream(stderr, STDERR)
    end

    stdin_thread = Thread.new do
      IO.copy_stream(STDIN, stdin)
    end

    puts "Return code: #{thread.value}"

    stdin_thread.join
    stdout_thread.join
    stderr_thread.join
  end
end

exec('terraform destroy')
