# Demonstrates that [Var.new('a')] & [Var.new('b')] is not empty when #eql? is true and hash comparison fails in Ruby 2.5.0. Works in Ruby 2.4.2.
# The documentation for Array#& says it uses both hash and eql?, but it seems to not be true in Ruby 2.5.0
class Var
  attr_reader :v

  def initialize(v)
    @v = v
  end

  def eql?(other)
    true
  end

  def hash
    v.hash
  end
end

def test_small_array_intersection
  list_a = [ Var.new('a') ]
  list_b = [ Var.new('b') ]

  report(list_a, list_b)
end

def test_large_array_intersection
  # An array is considered to be 'large' if it has > 16 elements
  list_a = 17.times.collect {|i| Var.new('a') }
  list_b = 17.times.collect {|i| Var.new('b') }

  report(list_a, list_b)
end

def report(a, b)
  if (a & b).empty?
    puts caller.first + ": success"
  else
    puts caller.first + ": failure"
  end
end

puts "RUBY_VERSION: #{RUBY_VERSION}"
test_small_array_intersection
test_large_array_intersection