require 'socket'
require 'openssl'

socket = Socket.tcp_server_sockets('127.0.0.1', 9876).first

con,_ = socket.accept

cert_store = OpenSSL::X509::Store.new
cert_store.set_default_paths
cert_store.verify_callback = lambda do |preverify_ok, store_ctx|
  true
end

ctx = OpenSSL::SSL::SSLContext.new
ctx.key = OpenSSL::PKey::RSA.new(File.open('server.key'))
ctx.cert = OpenSSL::X509::Certificate.new(File.open('server.crt'))
ctx.min_version = :TLS1_2
ctx.verify_mode = OpenSSL::SSL::VERIFY_PEER | OpenSSL::SSL::VERIFY_FAIL_IF_NO_PEER_CERT
ctx.cert_store = cert_store

ssl_socket = OpenSSL::SSL::SSLSocket.new(con, ctx)
ssl_socket.sync_close = true

ssl_socket.accept

pp ssl_socket.peer_cert

ssl_socket.close
