# frozen_string_literal: true

require 'timeout'
# Object container
class Obj
  attr_accessor :payload
  def initialize(value)
    @payload = value
  end
end

def random_hash(n = 2)
  return 'str' if n <= 0
  ret = {}
  10.times do |i|
    ret["key#{i}"] = random_hash(n - 1)
  end
  Obj.new(ret)
end

def log(x)
  warn("#{Process.pid}.#{Thread.current.object_id}: #{x}")
end

log('Starting')
queue = Queue.new

Thread.new do
  log("Consumer parent thread #{queue.object_id}")
  event = nil
  while event.nil?
    begin
      event = Timeout.timeout(1) do
        queue.pop
      end
    rescue Timeout::Error
      nil
    end
  end
  log("Consumer end parent thread #{queue.object_id}")
end
sleep(1)
log('Forking')
child_id = fork
if child_id.nil?
  Thread.new do
    log("Consumer thread #{queue.object_id}")
    event = nil
    while event.nil?
      begin
        event = Timeout.timeout(1) do
          queue.pop
        end
      rescue Timeout::Error
        nil
      end
    end
    log("Consumer end thread #{queue.object_id}")
  end
  sleep(1)
  h = random_hash(4)
  queue.push(h)
  log('finished child')
else
  Process.wait(child_id)
  log('finished parent')
end
