require 'benchmark'

def rest_method(*arr)
  final_method(*arr)
end

def lead_method(first, *arr)
  final_method(first, *arr)
end

def post_method(*arr, last)
  final_method(*arr, last)
end

def lead_post_method(first, *arr, last)
  final_method(first, *arr, last)
end

def benchmark_method(a, b, c, d, e)
  final_method(a, b, c, d, e)
end

def final_method(a, b, c, d, e)
  a + b + c + d + e
end

def rest_with_named_parameter(*arr, ignore:)
  final_method(*arr)
end

lead_proc = proc{|a,b,c,d,*rest| a + b + c + a + b + c}
opt_post_proc = proc{|a,b,c=-1,d=-1, e,f| a + b + c + d + e + f}


N = 3_000_000

param_1_to_5_with_hash = [1,2,3,4,5, ignore: 1]
param_1_to_3 = [1,2,3]
param_1_to_7 = [1,2,3,4,5,6,7]

Benchmark.bmbm do |b|
  b.report('benchmark_method') { N.times{ benchmark_method 1,2,3,4,5 } }
  b.report('rest_method') { N.times{ rest_method 1,2,3,4,5 } }
  b.report('lead_method') { N.times{ lead_method 1,2,3,4,5 } }
  b.report('post_method') { N.times{ post_method 1,2,3,4,5 } }
  b.report('lead_post_method') { N.times{ lead_post_method 1,2,3,4,5 } }
  b.report('rest_with_named_parameter') { N.times{ rest_with_named_parameter *param_1_to_5_with_hash } }
  b.report('lead_proc underflow_args') { N.times{ lead_proc.call *param_1_to_3 } }
  b.report('opt_post_proc overflow_args') { N.times{ opt_post_proc.call *param_1_to_7 } }
end
