require 'benchmark_driver'
max = 40

Benchmark.driver do |x|
  prelude = <<~RUBY
    class A0
      def foo
      end
    
      def foo0
      end
    end
  RUBY
    
  i = 0
  while i < max
    i += 1
    prelude << <<~RUBY
      class A#{i} < A#{i - 1}
        def foo
          super
        end
        def foo#{i}
          foo#{i - 1}
        end
      end
    RUBY
  end

  prelude << <<~RUBY
    if RubyVM::MJIT.enabled?
      a = eval("A#{max}").new
      10.times { a.foo }
      RubyVM::MJIT.pause
    end

    a = A#{max}.new
  RUBY

  if ENV["PERF_STAT"]
    puts "perf stat target: #{ENV["PERF_STAT"]}"
    prelude << <<~RUBY
      $pid = Process.spawn("perf stat -e #{ENV["PERF_STAT"]} -p \#{$$}")
      at_exit { Process.kill :INT, $pid }
    RUBY
  end

  x.rbenv 'trunk', 'trunk,--jit', 'export-big-func', 'export-big-func,--jit'
  x.prelude prelude

  x.report %{ a.foo }
end

