puts RUBY_VERSION


def test_args(input, method)
  print "  args    "
  begin
    l = lambda {|a,b| }
    ret = input.send(method, &l)
    puts "✅"
  rescue => e
    puts "💣 " + e.message
  end
end

def _test_return(input, method)
  l = lambda {|*| return :block }
  input.send(method, &l)
  return :lambda
end

def test_return(input, method)
  print "  return  "
  case _test_return(input, method)
  when :lambda
    puts "✅ lambda return semantics"
  when :block
    puts "❌ block return semantics"
  end
end

input = [[1,2]]

puts "Array#map"
test_args(input, :map)
test_return(input, :map)

puts "Enumerable#map"
test_args(input.map, :map)
test_return(input.map, :map)

puts "Array#each"
test_args(input, :each)
test_return(input, :each)

puts "Array#map!"
test_args(input.dup, :map!)
test_return(input.dup, :map!)
