# frozen_string_literal: true
require "bundler/inline"

gemfile(true) do
  source "https://rubygems.org"
  gem "benchmark-ips"
end

def bench_for_key_length(length)
  string_key = 'a' * length
  string_key = -string_key
  symbol_key = string_key.to_sym

  string_keyed_hash = { string_key => 1 }
  symbol_keyed_hash = { symbol_key => 1 }

  Benchmark.ips do |x|
    x.report("string key length=#{length}") { string_keyed_hash[string_key] }
    x.report("symbol key length=#{length}") { symbol_keyed_hash[symbol_key] }
    x.compare!
  end
end

bench_for_key_length(10)
bench_for_key_length(20)
