require 'benchmark'

N = 100_000

Benchmark.bm(60) do |x|
  x.report('normal class and module definition') do
    N.times do
      class A
        module B
          module C
          end
        end

        module D
        end

        module E
          class F
          end
        end
      end

      class Object
        remove_const(:A)
      end
    end
  end

  x.report('assign annoymous class to constant after class_eval') do
    N.times do
      c = Class.new
      c.class_eval("module A; end; module B;end")
      Klass = c
      Object.send(:remove_const, :Klass)
    end
  end

  [5, 10, 20, 50, 100, 1_000, 10_000, 50000].each do |nesting_level|
    x.report("assign structure nested for #{nesting_level} levels to constant") do
      c = Class.new
      c::DeepNesting = Module.new
      current = c::DeepNesting
      nesting_level.times do |i|
        current::Deeper = Module.new
        current = current::Deeper
      end

      Klass = c
      Object.send(:remove_const, :Klass)
    end
  end
end

<<-BEFORE_PATCH # r67513
                                                                   user     system      total        real
normal class and module definition                             0.429538   0.000000   0.429538 (  0.430925)
assign annoymous class to constant after class_eval            5.587715   0.000000   5.587715 (  5.605187)
assign structure nested for 5 levels to constant               0.000025   0.000000   0.000025 (  0.000024)
assign structure nested for 10 levels to constant              0.000008   0.000000   0.000008 (  0.000007)
assign structure nested for 20 levels to constant              0.000012   0.000000   0.000012 (  0.000011)
assign structure nested for 50 levels to constant              0.000026   0.000000   0.000026 (  0.000026)
assign structure nested for 100 levels to constant             0.000053   0.000000   0.000053 (  0.000053)
assign structure nested for 1000 levels to constant            0.000564   0.000000   0.000564 (  0.000564)
assign structure nested for 10000 levels to constant           0.008585   0.000000   0.008585 (  0.008608)
BEFORE_PATCH

<<-AFTER_PATCH
                                                                   user     system      total        real
normal class and module definition                             0.413949   0.003038   0.416987 (  0.417561)
assign annoymous class to constant after class_eval            1.364841   0.003332   1.368173 (  1.370387)
assign structure nested for 5 levels to constant               0.000012   0.000000   0.000012 (  0.000012)
assign structure nested for 10 levels to constant              0.000012   0.000000   0.000012 (  0.000011)
assign structure nested for 20 levels to constant              0.000018   0.000000   0.000018 (  0.000019)
assign structure nested for 50 levels to constant              0.000069   0.000000   0.000069 (  0.000070)
assign structure nested for 100 levels to constant             0.000550   0.000004   0.000554 (  0.000555)
assign structure nested for 1000 levels to constant            0.000000   0.002996   0.002996 (  0.003014)
assign structure nested for 10000 levels to constant           0.120534   0.076741   0.197275 (  0.198107)
AFTER_PATCH
