# This program allows you to play the famed high_low card game you know and love
# only now with a GUI!
# A card is dealt from a deck of cards.
# You have to predict whether the next card will be higher or lower

require 'Qt4'
require_relative 'deck.rb'

class HighLowField < Qt::Widget
	signals 'averageScoreChanged(float)', 'scoreChanged(int)'
	slots 'lowPressed()', 'highPressed()', 'startClicked()'

	def initialize(parent = nil)
		super

		setPalette(Qt::Palette.new(Qt::Color.new(250,250,200)))
	
		@current_card = nil
		@next_card = nil
		@playing = false # Checks if a game is currently playing	setAutoFillBackground(true)
		@total_score = 0
		@average_score = 0.0
		@games_played = 0
		@message = nil # Message sent to the player
		@image = Qt::Image.new("cards.png")
	end

	def paintEvent(event)
		painter = Qt::Painter.new(self)
		if(@playing) then
			draw_cards(painter)
		else
			painter.drawText(Qt::Rect.new, Qt::Rect.new, "Click to start a new game!")
		end
		painter.end
	end

	def draw_cards(painter)
		# Draw the current card
		source_y = @current_card.suit * 123
		source_x = (@current_card.value-1) * 79

		target_y = 100
		target_x = 100

		target = Qt::Rect.new(target_x.to_i, target_y.to_i, 79, 123)
		source = Qt::Rect.new(source_x.to_i, source_y.to_i, 79, 123)
		painter.drawImage(target, @image, source)

		# Draw the next card
		if(next_card != nil) then
			source_y = @next_card.suit * 123
			source_x = (@next_card.value-1) * 79

			target_x = 200

			target.setRect(target_x.to_i, target_y.to_i, 79, 123)
			source.setRect(source_x.to_i, source_y.to_i, 79, 123)
			painter.drawImage(target, @image, source)
		end

		# TODO Draw the message to the player down here
	end

	def play()
		deck = Deck.new

		correct_guesses = 0

		guess = nil

		deck.shufle

		current_card = deck.deal_card
		# TODO The rest of this method is not finished yet!
	end
end

class HighLowWidget < Qt::Widget
	def initialize(parent = nil)
		setWindowTitle("High Low Card Game!")
		puts("Initializing HighLowWidget")
		super

		higher = Qt::PushButton.new(tr("Higher"))
		font = Qt::Font.new('Times', 18, Qt::Font::Bold)
		higher.setFont(font)
		lower = Qt::PushButton.new(tr("Lower"))
		lower.setFont(font)
		highLowField = HighLowField.new

		connect(higher, SIGNAL("clicked()", highLowField, SLOT("highPressed()"))) 

		connect(lower, SIGNAL("clicked()", highLowField, SLOT("lowPressed()")))

		current_score = Qt::LCDRange.new
		current_score.setRange(0, 54)

		average_score = Qt::LCDRange.new
		average_score.setRange(0, 54)

		leftLayout = Qt::VBoxLayout.new
		leftLayout.addWidget(current_score)
		leftLayout.addWidget(average_score)

		gridLayout = Qt::GridLayout.new
		gridLayout.addWidget(highLowField, 0, 0)
		gridLayout.addLayout(leftLayout, 1, 0)
		gridLayout.addWidget(higher, 1, 1, 2, 1)
		gridLayout.addWidget(lower, 1, 2, 2, 1)
		gridLayout.setColumnStretch(1, 10)
		setLayout(gridLayout)
	end
end

app = Qt::Application.new(ARGV)

widget = HighLowWidget.new
p(widget)
puts("HighLowWidget should be ready by now.")
widget.resize(500, 500)
widget.show()
app.exec

