# frozen_string_literal: true
require "benchmark/ips"

def deep_dup_case(obj)
  case obj
  when Integer, Float, TrueClass, FalseClass, NilClass
    1
  when String
    2
  when Array
    sum = 0
    obj.map { |e| sum += deep_dup_case(e) }
    sum
  when Hash
    sum = 0
    obj.each_pair do |key, value|
      sum += deep_dup_case(key) + deep_dup_case(value)
    end
    sum
  else
    1
  end
end

def deep_dup_if(obj)
  if Integer === obj || Float === obj || TrueClass === obj || FalseClass === obj || NilClass === obj
    1
  elsif String === obj
    2
  elsif Array === obj
    sum = 0
    obj.map { |e| sum += deep_dup_if(e) }
    sum
  elsif Hash === obj
    sum = 0
    obj.each_pair do |key, value|
      sum += deep_dup_if(key) + deep_dup_if(value)
    end
    sum
  else
    obj.dup
  end
end


obj = { "class" => "FooWorker", "args" => [1, 2, 3, "foobar"], "jid" => "123987123" }

Benchmark.ips do |x|
  x.report("deep_dup_case") do
    deep_dup_case(obj)
  end

  x.report("deep_dup_if") do
    deep_dup_if(obj)
  end

  x.compare!
end
