require 'bundler/inline'

gemfile do
  source 'https://rubygems.org'

  gem 'memory_profiler'
end

require 'memory_profiler'

class FooWithPlainParams
  def initialize(a, b, c)
    @a = a
    @b = b
    @c = c
  end
end

class FooWithOptionsHash
  def initialize(options = {})
    @a = options[:a]
    @b = options[:b]
    @c = options[:c]
  end
end

class FooWithKeyword
  def initialize(a:, b:, c:)
    @a = a
    @b = b
    @c = c
  end
end

RUNS = 100

puts 'FooWithPlainParams'
MemoryProfiler.report do
  RUNS.times do
    FooWithPlainParams.new(1, 2, 3)
  end
end.pretty_print

puts 'FooWithOptionsHash'
MemoryProfiler.report do
  RUNS.times do
    FooWithOptionsHash.new(a: 1, b: 2, c: 3)
  end
end.pretty_print

puts 'FooWithKeyword'
MemoryProfiler.report do
  RUNS.times do
    FooWithKeyword.new(a: 1, b: 2, c: 3)
  end
end.pretty_print
