# encoding: UTF-8

# NOTE: I've only enabled for win32 for now, but I presume
# these tests would also apply to other platforms with
# unicode paths, like Linux and OS X

if RUBY_PLATFORM =~ /win32/

assert_equal 'ok', %q{
  require 'tmpdir'
  FNAME_CHINESE = "\u52ec\u52ee\u52f1\u52f2.txt"
  DNAME_CHINESE = "\u52ec\u52ee\u52f1\u52f2"
  Dir.mkdir DNAME_CHINESE
  test(?d, DNAME_CHINESE) or raise "test ?d fail"
  fpath = File.join(DNAME_CHINESE, FNAME_CHINESE)
  File.open(fpath, "w") {|io| io.puts "Hello, World"}
  dat = File.read(fpath)
  ( dat == "Hello, World\n" ) or raise "fpath read fail"
  test(?f, fpath) or raise "test ?f fail"
  
  Dir.chdir DNAME_CHINESE
  cwd = Dir.pwd
#### FIXME: Dir.pwd is returning "Windows-1252" encoding
# cwd.force_encoding("UTF-8")
  ( cwd[(-DNAME_CHINESE.length)..-1] == DNAME_CHINESE ) or raise "cwd check fail"
  :ok
}

# TODO: File.unlink, File.stat, Dir.rmdir, Dir.open, ...

end
