require 'socket'

module LazyRack
  class Server
    def initialize(port:, addr:, app:)
      @port = port
      @addr = addr
      @app = app
    end

    attr_reader :addr, :port

    def serve!
      puts "Listening on #{@addr}:#{@port}"
      socket = Socket.new(:INET, :STREAM)
      socket.bind(Addrinfo.tcp(@addr, @port))
      socket.listen(1)

      loop do
        client, client_addr = socket.accept

        ractor = Ractor.new(name: "lazy-rack-server-#{client_addr.ip_address}") do
          client_sock_t = Ractor.recv
          client_addr_t = Ractor.recv
          app = Ractor.recv
          RequestServer.new(client_sock_t, client_addr_t, app).serve!
        end

        ractor.send(client, move: true)
        ractor.send(client_addr.freeze)
        ractor.send(@app)
      end

    ensure
      puts "Closing socket..."
      socket.close
    end
  end
end
