require_relative 'lib/lazy_rack/version'

Gem::Specification.new do |spec|
  spec.name          = "lazy_rack"
  spec.version       = LazyRack::VERSION
  spec.authors       = ["Anthony Super"]
  spec.email         = ["anthony@noided.media"]

  spec.summary       = %q{A lazily-written ractor-based webserver}
  spec.description   = <<~TEXT
    This is an extremely lazily-written, basic Rack server.
    It has one root process that runs an accept loop, and then forks off a new ractor
    to run your code.

    Probably incompatible with literally every single framework at the moment (as none of them are Ractor-safe),
    I hope it's at least a research curiosity. 
  TEXT
  # spec.homepage      = ""
  spec.license       = "MIT"
  spec.required_ruby_version = Gem::Requirement.new("~> 3.0.0-preview1")

  # spec.metadata["allowed_push_host"] = "TODO: Set to 'http://mygemserver.com'"

  # spec.metadata["homepage_uri"] = spec.homepage
  # spec.metadata["source_code_uri"] = "TODO: Put your gem's public repo URL here."
  # spec.metadata["changelog_uri"] = "TODO: Put your gem's CHANGELOG.md URL here."

  # Specify which files should be added to the gem when it is released.
  # The `git ls-files -z` loads the files in the RubyGem that have been added into git.
  spec.files         = Dir.chdir(File.expand_path('..', __FILE__)) do
    `git ls-files -z`.split("\x0").reject { |f| f.match(%r{^(test|spec|features)/}) }
  end
  spec.bindir        = "exe"
  spec.executables   = spec.files.grep(%r{^exe/}) { |f| File.basename(f) }
  spec.require_paths = ["lib"]

  spec.add_dependency "rack", "~> 2.2.0"
end
