#!/usr/bin/env ruby

lines = [
  "a = 2, 1     if 1 < 2",
  "a = [2, 1]   if 1 < 2",
  "(a = 2, 1)   if 1 < 2",
  "(a = [2, 1]) if 1 < 2",
  "a = 2, 1     unless 2 < 1",
  "a = [2, 1]   unless 2 < 1",
  "(a = 2, 1)   unless 2 < 1",
  "(a = [2, 1]) unless 2 < 1",
  "a, b = 2, 1     if 1 < 2",
  "a, b = [2, 1]   if 1 < 2",
  "(a, b) = 2, 1   if 1 < 2",
  "(a, b) = [2, 1] if 1 < 2",
  "(a, b = 2, 1)   if 1 < 2",
  "(a, b = [2, 1]) if 1 < 2",
  "a, b = 2, 1     unless 2 < 1",
  "a, b = [2, 1]   unless 2 < 1",
  "(a, b) = 2, 1   unless 2 < 1",
  "(a, b) = [2, 1] unless 2 < 1",
  "(a, b = 2, 1)   unless 2 < 1",
  "(a, b = [2, 1]) unless 2 < 1",
  "1 < 2   and a = 2, 1",
  "1 < 2   and a = [2, 1]",
  "1 < 2   and (a = 2, 1)",
  "1 < 2   and (a = [2, 1])",
  "(1 < 2) and a = 2, 1",
  "(1 < 2) and a = [2, 1]",
  "(1 < 2) and (a = 2, 1)",
  "(1 < 2) and (a = [2, 1])",
  "1 < 2   and a, b = 2, 1",
  "1 < 2   and a, b = [2, 1]",
  "1 < 2   and (a, b) = 2, 1",
  "1 < 2   and (a, b) = [2, 1]",
  "1 < 2   and (a, b = 2, 1)",
  "1 < 2   and (a, b = [2, 1])",
  "(1 < 2) and a, b = 2, 1",
  "(1 < 2) and a, b = [2, 1]",
  "(1 < 2) and (a, b) = 2, 1",
  "(1 < 2) and (a, b) = [2, 1]",
  "(1 < 2) and (a, b = 2, 1)",
  "(1 < 2) and (a, b = [2, 1])",
  "2 < 1   or a = 2, 1",
  "2 < 1   or a = [2, 1]",
  "2 < 1   or (a = 2, 1)",
  "2 < 1   or (a = [2, 1])",
  "(2 < 1) or a = 2, 1",
  "(2 < 1) or a = [2, 1]",
  "(2 < 1) or (a = 2, 1)",
  "(2 < 1) or (a = [2, 1])",
  "2 < 1   or a, b = 2, 1",
  "2 < 1   or a, b = [2, 1]",
  "2 < 1   or (a, b) = 2, 1",
  "2 < 1   or (a, b) = [2, 1]",
  "2 < 1   or (a, b = 2, 1)",
  "2 < 1   or (a, b = [2, 1])",
  "(2 < 1) or a, b = 2, 1",
  "(2 < 1) or a, b = [2, 1]",
  "(2 < 1) or (a, b) = 2, 1",
  "(2 < 1) or (a, b) = [2, 1]",
  "(2 < 1) or (a, b = 2, 1)",
  "(2 < 1) or (a, b = [2, 1])"
]

width = lines.map(&:size).max

for line in lines
  begin
    a = b = nil
    eval line
    raise "Value mismatched" unless [[2, 1], [[2, 1], nil]].member?([a, b])
    comment = "Works"
  rescue Exception => e
    comment = "#{e.class}: #{e.message.each_line.first&.chomp}"
  end
  puts "%-#{width}s # #{comment}" % line
end
