#!/usr/bin/env ruby

require 'pty'

if ARGV.length == 1
  $command = ARGV[0]
else
  $command = 'echo foo'
end

$exit_status = nil

begin
  PTY.spawn($command) do |r, w, pid|
    w.close
    begin
      r.each do |line|
        puts "Got line \"#{line.chomp}\""
      end
    rescue Errno::EIO
      # ignore
    rescue => e
      $stderr.puts "Read error: #{e}"
    ensure
      Process.wait pid
    end
    $exit_status = $?.exitstatus
  end
rescue => e
  $stderr.puts "PTY.spawn error: #{e}"
end

puts "Exit status #{$exit_status}"
