#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <sys/wait.h>

static void sir_local_alot(unsigned long count, int r)
{
    uint64_t start = clock_gettime_nsec_np(CLOCK_MONOTONIC);
    time_t t = time(NULL);
    const char *s = "";
    if (r) {
        s = "_r";
        for (unsigned long i = 0; i < count; ++i) {
            struct tm tm;
            localtime_r(&t, &tm);
        }
    }
    else {
        for (unsigned long i = 0; i < count; ++i) {
            localtime(&t);
        }
    }
    uint64_t n = clock_gettime_nsec_np(CLOCK_MONOTONIC) - start;
    printf("  localtime%-2s = %lld.%09u\n", s, n / 1000000000ULL, (unsigned int)(n % 1000000000ULL));
}

int main(int argc, char **argv)
{
#define COUNT 10000
    unsigned long count = COUNT;
    if ((argc > 1) && !(count = strtoul(argv[1], NULL, 0))) {
        fprintf(stderr, "invalid count: %s\n", argv[1]);
        return EXIT_FAILURE;
    }

    printf("Measuring in parent\n");
    sir_local_alot(count, 1);
    sir_local_alot(count, 0);

    printf("Measuring in child\n");
    pid_t pid = fork();
    if (!pid) {
        sir_local_alot(count, 1);
        sir_local_alot(count, 0);
    }
    wait(&pid);
    return EXIT_SUCCESS;
}
