# encoding: ascii-8bit

    it "has to handle various character sets" do
      # TODO: force_encoding should not be necessary if tmp returns suitable encoded path.
      unicode_dir = tmp('rubyspec_unicode').force_encoding 'utf-8'
      Dir.mkdir(unicode_dir)
      begin
        folder_us_ascii = File.join(unicode_dir, 'abcde')
        folder_us_ascii.force_encoding 'us-ascii'

        folder_utf_8 = File.join(unicode_dir, 'của_zufällige_žluťoučký_გამეორებ_разлога_和新加坡以及东')
        folder_utf_8.force_encoding 'utf-8'

        folder_cp1250 = File.join(unicode_dir, "luouk")
        folder_cp1250.force_encoding 'cp1250'

        Dir.mkdir folder_us_ascii
        Dir.mkdir folder_utf_8
        Dir.mkdir folder_cp1250

        files = Dir[File.join unicode_dir, "*"]

        files.should include(folder_us_ascii)
        files.should include(folder_utf_8)
        files.should include(folder_cp1250.encode('utf-8'))
      ensure
        # Use system calls. Ruby's rmdir could have problems to handle encodings correctly.
        platform_is(:windows) do
          system(%Q{rmdir /s /q "#{unicode_dir}"})
        end
        platform_is_not(:windows) do
          system("rm -rf #{unicode_dir}")
        end
      end
    end