#!/usr/bin/env ruby

# Use a pair of pipes that will make long_pid exit when
# this script exits, to avoid cluttering your computer with
# sleeping ruby processes.

rpipe, wpipe = IO.pipe

long_pid = fork do
    puts "long process (#{Process.pid}) starting"
    wpipe.close
    rpipe.read
    puts "long process (#{Process.pid}) exiting"
end
short_pid = fork do
    puts "short process (#{Process.pid}) starting"
    wpipe.close
    sleep 1
    puts "short process (#{Process.pid}) exiting"
end

Thread.new do
    puts "waiting for long process (#{long_pid}) in thread"
    Process.waitpid2 long_pid
end

sleep 0.5
puts "waiting for any process"
wpid, status = Process.waitpid2 -1
puts "waitpid2 returned (#{wpid}, #{status})"
exit! 0
