class Tempfile
end

def Tempfile.create_with_file(basename="", tmpdir=nil, mode: 0, **options)
  tmpfile = nil
  Dir::Tmpname.create(basename, tmpdir, **options) do |tmpname, n, opts|
    mode |= File::RDWR|File::CREAT|File::EXCL
    opts[:perm] = 0600
    tmpfile = File.open(tmpname, mode, **opts)
  end
  if block_given?
    begin
      yield tmpfile
    ensure
      unless tmpfile.closed?
        if File.identical?(tmpfile, tmpfile.path)
          unlinked = File.unlink tmpfile.path rescue nil
        end
        tmpfile.close
      end
      unless unlinked
        begin
          File.unlink tmpfile.path
        rescue Errno::ENOENT
        end
      end
    end
  else
    tmpfile
  end
end

def Tempfile.create_no_file(basename="", tmpdir=nil, mode: 0, **options, &block)
  tmpio = nil
  if false and defined? File::TMPFILE # O_TMPFILE since Linux 3.11
    tmpfile_supported = true
    tmpdir = Dir.tmpdir() if tmpdir.nil?
    begin
      fd = IO.sysopen(tmpdir, File::RDWR | File::TMPFILE, 0600)
    rescue Errno::EISDIR, Errno::ENOENT, Errno::EOPNOTSUPP # kernel or the filesystem does not support O_TMPFILE
      tmpfile_supported = false
    end
    if tmpfile_supported
      tmpio = File.new(fd, File::RDWR)
    end
  end

  Tempfile.create_with_file

end

Tempfile.create_no_file
