#!/usr/bin/env ruby
# Reproduction script for macOS 26.x DNS fork bug
# Run with: ruby ruby_dns_fork_bug.rb
#
# Note: Remove the Timeout.timeout(90) wrapper to observe the hang
# indefinitely. The timeout is included only to allow the script to
# exit for testing purposes.

require "socket"
require "timeout"

puts "Ruby #{RUBY_VERSION} on #{RUBY_PLATFORM}"
puts "Testing DNS resolution after fork..."

# Parent performs DNS lookup for IPv4-only host
Socket.getaddrinfo("api.segment.io", 443, nil, :STREAM)
puts "Parent: DNS completed"

# Fork and try DNS in child
pid = fork do
  puts "Child: Attempting DNS resolution..."
  begin
    Timeout.timeout(90) do
      Socket.getaddrinfo("api.segment.io", 443, nil, :STREAM)
    end
    puts "Child: SUCCESS"
    exit 0
  rescue Timeout::Error
    puts "Child: FAILED - hung for 90 seconds"
    exit 1
  end
end

Process.wait(pid)
exit_code = $?.exitstatus

if exit_code == 0
  puts "PASS: Bug not present"
else
  puts "FAIL: Bug reproduced - DNS resolution hung after fork"
end

exit exit_code
