#include <ruby.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>

static VALUE
io_syssocket(VALUE klass, VALUE domain, VALUE type, VALUE protocol)
{
	int s;

	s = socket(NUM2INT(domain), NUM2INT(type), NUM2INT(protocol));
	if (s < 0) rb_sys_fail("socket");
	return INT2FIX(s);
}

static VALUE
io_sysclose(VALUE klass, VALUE fd)
{
	int r;

	r = close(NUM2INT(fd));
	if (r < 0) rb_sys_fail("sysclose");

	return INT2FIX(r);
}

void
Init_iosyssocket()
{
	rb_define_singleton_method(rb_cIO, "syssocket", io_syssocket, 3);
	rb_define_singleton_method(rb_cIO, "sysclose", io_sysclose, 1);
}
