require 'drb'

# pass anything as an arg to make this script fail
borked_mode = ARGV.shift 

# The RPC Server Class
class Foo
	def a
		"AAAA"
	end
	def b
		"BBBB"
	end
	def c
		"CCCC"
	end
end

# Save all the child pids
pids = []

# Run the RPC Server in a seperate process
pids << Kernel.fork do
	DRb.start_service("druby://127.0.0.1:13370",Foo.new)
	sleep # until process gets killed
end
sleep(1)

# If the parent process calls any remote method at all, the child PIDs get invalid data
client = DRbObject.new_with_uri("druby://127.0.0.1:13370")

# Comment this line and this script works, otherwise data gets mixed up.
client.c if borked_mode

# Startup 10 child processes that call 'a' on the rpc server
10.times do
	pids << Kernel.fork do 
		require 'drb'
		begin
			client = DRbObject.new_with_uri("druby://127.0.0.1:13370")
			while true
				res = client.a
				if res !~ /AAAA/
					puts "A BAD RESULT (#{res.inspect})" 
				else
					puts "a ok"
				end
				sleep(0.2)
			end
		rescue
			puts "a exiting"
		end
	end
end

# Startup 10 child processes that call 'b' on the rpc server
10.times do
	pids << Kernel.fork do 
		require 'drb'
		begin
			client = DRbObject.new_with_uri("druby://127.0.0.1:13370") 
			while true
				res = client.b
				if res !~ /BBBB/
					puts "B BAD RESULT (#{res.inspect})"
				else
					puts "b ok"
				end
				sleep(0.2)
			end
		rescue
			puts "b exiting"
		end
	end
end

sleep(5)

pids.each do |p|
	Process.kill('KILL',p) rescue nil
	Process.waitpid(p,Process::WNOHANG)
end

exit
