require 'thread'
require 'test/unit'

class ThreadPriorityTest<Test::Unit::TestCase
  def assert_greater_than a,b
    assert_operator a, :>, b
  end

  def test_priorities(priobase=nil,mult=nil)
    $c1=$c2=$c3=0

    priobase||=ENV['PRIOBASE']||'0'
    priobase=priobase.to_i

    mult||=ENV['PRIOGAP']||'1'
    mult=mult.to_i

    $m=Mutex.new
    $cv=ConditionVariable.new
    t3=Thread.new{ $m.synchronize{$cv.wait $m};  $c3+=1 while 1 }
    t2=Thread.new{ $m.synchronize{$cv.wait $m};  $c2+=1 while 1 }
    t1=Thread.new{ $m.synchronize{$cv.wait $m};  $c1+=1 while 1 }

    Thread.current.priority=priobase
    t1.priority=priobase
    t2.priority=priobase-1*mult
    t3.priority=priobase-2*mult
    sleep 0.2
    $m.synchronize{$cv.broadcast}

    sleep 10
    t1.kill; t2.kill; t3.kill

    if ENV['VERBOSE']
      p [:c1=, $c1]
      p [:c2=, $c2]
      p [:c3=, $c3]
      p [:total, $c1+$c2+$c3]
    end

    assert_greater_than $c1, 1.1*$c2
    assert_greater_than $c2, 1.1*$c3

  ensure
    Thread.current.priority=0
  end
end
