#!/usr/bin/env ruby1.9
# (ulimit -n 16; ./lazy_path_test.rb ~/src/ruby-trunk)

require 'pathname'
require "fileutils"

class Pathname
  def each_child(with_directory=true)
    block_given? or return enum_for(__method__, with_directory)
    with_directory = false if @path == '.'
    Dir.foreach(@path) {|e|
      next if e == '.' || e == '..'
      if with_directory
        yield self.class.new(File.join(@path, e))
      else
        yield self.class.new(e)
      end
    }
  end
  
  def find_files(&blk)
    if directory?
      each_child{|c| c.find_files(&blk) }
    else
      yield self
    end
  end
end

("00".."99").each{|d|
  FileUtils.mkdir_p d
  ("a".."z").each{|f| FileUtils.touch "#{d}/#{f}"}
}

puts "Ulimit is #{`ulimit -n`}" # As low as 16 works
root = Pathname(ARGV[0] || ".")

puts "Test 1" # Passes
root.each_child.select(&:directory?).map(&:each_child).each{|subdir| puts subdir.take(5) }

puts "Test 2" # Passes
root.find_files{|f| puts f}

puts "Test 3" # ./lazy_path_test.rb:45:in `open': Too many open files 
root.children.map{|d| Dir.open(d) if d.directory? }
