diff --git a/ext/objspace/objspace.c b/ext/objspace/objspace.c
index 817380f..ebca2f8 100644
--- a/ext/objspace/objspace.c
+++ b/ext/objspace/objspace.c
@@ -141,6 +141,9 @@ memsize_of(VALUE obj)
 	}
 	break;
 
+      case T_ZOMBIE:
+	break;
+
       default:
 	rb_bug("objspace/memsize_of(): unknown data type 0x%x(%p)",
 	       BUILTIN_TYPE(obj), (void*)obj);
diff --git a/gc.c b/gc.c
index db3dce5..1eaa3d0 100644
--- a/gc.c
+++ b/gc.c
@@ -1176,7 +1176,7 @@ rb_data_typed_object_alloc(VALUE klass, void *datap, const rb_data_type_t *type)
 size_t
 rb_objspace_data_type_memsize(VALUE obj)
 {
-    if (RTYPEDDATA_P(obj)) {
+    if (RTYPEDDATA_P(obj) && RTYPEDDATA_TYPE(obj)->function.dsize) {
 	return RTYPEDDATA_TYPE(obj)->function.dsize(RTYPEDDATA_DATA(obj));
     }
     else {
diff --git a/test/objspace/test_objspace.rb b/test/objspace/test_objspace.rb
new file mode 100644
index 0000000..cfdb485
--- /dev/null
+++ b/test/objspace/test_objspace.rb
@@ -0,0 +1,44 @@
+require "test/unit"
+require "objspace"
+
+class TestObjSpace < Test::Unit::TestCase
+  def test_memsize_of
+    assert_equal(0, ObjectSpace.memsize_of(true))
+    assert_kind_of(Integer, ObjectSpace.memsize_of(Object.new))
+    assert_kind_of(Integer, ObjectSpace.memsize_of(Class))
+    assert_kind_of(Integer, ObjectSpace.memsize_of(""))
+    assert_kind_of(Integer, ObjectSpace.memsize_of([]))
+    assert_kind_of(Integer, ObjectSpace.memsize_of({}))
+    assert_kind_of(Integer, ObjectSpace.memsize_of(//))
+    f = File.new(__FILE__)
+    assert_kind_of(Integer, ObjectSpace.memsize_of(f))
+    f.close
+    assert_kind_of(Integer, ObjectSpace.memsize_of(/a/.match("a")))
+    assert_kind_of(Integer, ObjectSpace.memsize_of(Struct.new(:a)))
+  end
+
+  def test_count_objects_size
+    res = ObjectSpace.count_objects_size
+    assert_equal(false, res.empty?)
+    assert_equal(true, res[:TOTAL] > 0)
+    arg = {}
+    ObjectSpace.count_objects_size(arg)
+    assert_equal(false, arg.empty?)
+  end
+
+  def test_count_nodes
+    res = ObjectSpace.count_nodes
+    assert_equal(false, res.empty?)
+    arg = {}
+    ObjectSpace.count_nodes(arg)
+    assert_equal(false, arg.empty?)
+  end
+
+  def test_count_tdata_objects
+    res = ObjectSpace.count_tdata_objects
+    assert_equal(false, res.empty?)
+    arg = {}
+    ObjectSpace.count_tdata_objects(arg)
+    assert_equal(false, arg.empty?)
+  end
+end
