##
##  usage: ruby -s bench.rb [-N=100000]
##
##  ex.
##     $ ./ruby bench.rb
##                                         user     system      total        real
##     caller()[0]                     1.890000   0.010000   1.900000 (  1.941812)
##     caller()[0] (retrieve)          2.190000   0.010000   2.200000 (  2.225966)
##     called_from()                   0.100000   0.000000   0.100000 (  0.102810)
##     called_from() (retrieve)        0.100000   0.000000   0.100000 (  0.102133)
##

require 'benchmark'

def f1; f2; end
def f2; f3; end
def f3; f4; end
def f4; f5; end
def f5; f6; end
def f6; f7; end
def f7; f8; end
def f8; f9; end
def f9; f10; end

n = ($N || 100000).to_i

Benchmark.bm(30) do |x|

  ## benchmarks for caller()

  def f10
    caller()[0]
  end

  x.report("caller()[0]") do
    n.times { f1() }
  end

  x.report("caller()[0] (retrieve)") do
    n.times { f1() =~ /:(\d+)/; fname = $`; lnum = $1.to_i }
  end

  ## benchmarks for called_from()

  def f10
    called_from()
  end

  x.report("called_from()") do
    n.times { f1() }
  end

  x.report("called_from() (retrieve)") do
    n.times { fname, lnum, func_name = f1(); }
  end

end
