# coding: cp932
require 'test/unit'

if RUBY_PLATFORM =~ /mswin/ && Encoding.locale_charmap == 'CP932'
  class TestErrnoMessage < Test::Unit::TestCase
    E = [
         Errno::EWOULDBLOCK,
         Errno::EINPROGRESS,
         Errno::EALREADY,
         Errno::ENOTSOCK,
         Errno::EDESTADDRREQ,
         Errno::EMSGSIZE,
         Errno::EPROTOTYPE,
         Errno::ENOPROTOOPT,
         Errno::EPROTONOSUPPORT,
         Errno::ESOCKTNOSUPPORT,
         Errno::EOPNOTSUPP,
         Errno::EPFNOSUPPORT,
         Errno::EAFNOSUPPORT,
         Errno::EADDRINUSE,
         Errno::EADDRNOTAVAIL,
         Errno::ENETDOWN,
         Errno::ENETUNREACH,
         Errno::ENETRESET,
         Errno::ECONNABORTED,
         Errno::ECONNRESET,
         Errno::ENOBUFS,
         Errno::EISCONN,
         Errno::ENOTCONN,
         Errno::ESHUTDOWN,
         Errno::ETOOMANYREFS,
         Errno::ETIMEDOUT,
         Errno::ECONNREFUSED,
         Errno::ELOOP,
         Errno::ENAMETOOLONG,
         Errno::EHOSTDOWN,
         Errno::EHOSTUNREACH,
         Errno::EPROCLIM,
         Errno::EUSERS,
         Errno::EDQUOT,
         Errno::ESTALE,
         Errno::EREMOTE,
        ]  
    M = [
         'ubNs̃\PbgɊł܂łB',
         'ubNsłB',
         'ɑ삪is̃ubNs̃\Pbgɑ΂āAs悤Ƃ܂B',
         '\PbgȊÔ̂ɑ΂đs悤Ƃ܂B',
         '\Pbg̑삩KvȃAhXȗ܂B',
         'f[^O \PbgőMꂽbZ[WÃbZ[W̃obt@[܂͂ق̃lbg[N̐𒴂Ă܂B܂́Af[^O̎MɎgobt@[f[^O菬ݒ肳Ă܂B',
         '\Pbg̊֐ĂяoŃvgRw肳܂Av\Pbg̎ނ̌`T|[gĂ܂B',
         'getsockopt ܂ setsockopt ̌ĂяoŎw肳ꂽIvV܂̓x́AsAA邢̓T|[gĂ܂B',
         'vvgRVXeɍ\ĂȂA܂݂͑܂B',
         'w肵\Pbg̎ނ́ÃAhX t@~ŃT|[gĂ܂B',
         's悤Ƃ́AQƂIuWFNg̎ނł̓T|[gĂ܂B',
         'vgR t@~VXeɍ\ĂȂA܂݂͑܂B',
         'vvgRƌ݊ȂAhXgp܂B',
         'ʏAe\Pbg AhXɑ΂ăvgRAlbg[N AhXA܂̓|[ĝǂꂩ 1 ݂̂gpł܂B',
         'vAhX̃ReLXgłB',
         '\Pbgɂlbg[N̒~o܂B',
         'BłȂlbg[NŃ\Pbgs悤Ƃ܂B',
         '̎s keep-alive ɂăG[oꂽ߁Aڑؒf܂B',
         'mꂽڑzXg Rs[^[̃\EgEFAɂĒ~܂B',
         '̐ڑ̓[g zXgɋIɐؒf܂B',
         'VXẽobt@[̈悪sĂ邩A܂̓L[ςȂ߁A\Pbgsł܂łB',
         'ɐڑς݂̃\Pbgɑ΂Đڑv܂B',
         '\PbgڑĂȂAsendto Ăяogăf[^O \PbgőMƂɃAhXw肳ĂȂ߁Af[^̑Mv邱Ƃ͋ւĂ܂B',
         '\PbgȑÕVbg_ĚĂяoŃVbg_EĂ邽߁Af[^̑Mv邱Ƃ͋ւĂ܂B',
         'J[l IuWFNgւ̎QƂ܂B',
         'ڑς݂̌Ăяo悪̎Ԃ߂ĂȂ߁Aڑł܂łB܂͐ڑς݂̃zXgȂ߁Amꂽڑ͎s܂B',
         'Ώۂ̃Rs[^[ɂċۂꂽ߁Aڑł܂łB',
         'Oϊł܂B',
         'Filename too long',
         '̃zXg~Ă邽߁A\Pbgsł܂łB',
         'BłȂzXgɑ΂ă\Pbgs悤Ƃ܂B',
         'Windows Sockets ꍇA𓯎ɎgpłAvP[V̐Ăꍇ܂B',
         'NH[^sĂ܂B',
         'fBXN NH[^sĂ܂B',
         't@C nh̎QƂ𗘗pł܂B',
         'ڂ̓[Jŗpł܂B',
        ]
    def test_message
      E.zip(M).each do |e, m|
        assert_equal(m, e.new.message.force_encoding('cp932'), e.to_s)
      end
    end
  end
end

