
#include <iostream>
#include <string>
#include <fstream>
#include <sstream>
#include <vector>

#include <ruby.h>

#define MYRAND(r) (rand()%r)

using namespace std;

static VALUE obj;

typedef void (MessyFunc)(void *);

typedef VALUE (*RubyGenericFunc)(...);

static bool use_messy = true;
static bool use_ruby = true;
static bool use_rand_vals = true;
static bool verbose = false;
static bool use_rand_stack_size = true;
static bool use_gc = true;

static VALUE RubyP(int argc, VALUE *argv, VALUE self)
{
  (void)self;
  VALUE str = rb_str_new("", 0);
  for (int i=0; i<argc; i++)
  {
    if (i > 0)
      rb_str_cat(str, ", ", 2);
    rb_str_concat(str, rb_inspect(argv[i]));
  }
  //cerr << "[" << RSTRING(str)->ptr << "]"; cerr.flush();
  return Qnil;
}

static VALUE RubySafeGCX(VALUE a)
{
  (void)a;
  if (use_gc)
    rb_gc();
  return Qnil;
}

static VALUE RubySafeGC()
{
  int status;
  VALUE rv = rb_protect(RubySafeGCX, Qnil, &status);
  if (status)
  {
    cerr << "Ruby reported error.\n";
    //VALUE einfo = rb_obj_as_string(ruby_errinfo);
    //cerr << "Ruby reported error: " << status
    //<< " " << RSTRING(einfo)->ptr << ".\n";
  }
  return rv;
}

static void RubySafeGCZ(void *t)
{
  (void)t;
  RubySafeGC();
}

static void InitRuby(void *t)
{
  (void)t;
  ruby_init();
  RubySafeGC();
}

static void InitRuby2(void *t)
{
  (void)t;
  rb_define_global_function("p", (RubyGenericFunc)RubyP, -1);
}

static void InitRuby3(void *t)
{
  (void)t;
  int status;
  rb_eval_string_protect(
    "class Foo\n"
    "  def initialize(z)\n"
    "    @a = z\n"
    "  end\n"
    "   def update(v)\n"
    "     p(v)\n"
    "   end\n"
    "end\n"
    , &status);
  if (status)
  {
    cerr << "Ruby reported error.\n";
    //VALUE einfo = rb_obj_as_string(ruby_errinfo);
    //cerr << "Ruby reported error: " << status
    //<< " " << RSTRING(einfo)->ptr << ".\n";
  }
}

static void InitRuby4(void *t)
{
  (void)t;
  VALUE c_foo = rb_const_get(rb_cObject, rb_intern("Foo"));
  VALUE c_bar = INT2NUM(555);
  rb_gc_register_address(&obj); // Thankyou Nobuyoshi Nakada. :)
  obj = rb_funcall(c_foo, rb_intern("new"), 1, c_bar);
  //rb_gc_register_mark_object(obj);
}

static void update(int i)
{
  rb_funcall(obj, rb_intern("update"), 1, INT2NUM(i));
}

static void update2(void *t)
{
  update(*((int *)t));
}

static void nonruby(int i)
{
  cerr << " " << i << "\n";
}

static void nonruby2(void *t)
{
  nonruby(*((int *)t));
}

static void Nothing(void *t)
{
  (void)t;
}

static void messy2(MessyFunc t, void *td, int depth, bool &done)
{
  // Add random crap to the stack that will be checked and reclaimed at
  // the end.
  int ss = 164;
  if (use_rand_stack_size)
    ss = MYRAND(40)*4+8;
  int mv = 0;
  if (use_rand_vals)
    mv = MYRAND(256);
  if (verbose)
    cerr << "Stack depth " << (depth+1) << " filled with " << mv << ".\n";
  unsigned char *data = (unsigned char *)alloca(ss);
  memset(data, mv, ss);

  for (int i=0; i<ss; i++)
  {
    if (data[i] != mv)
    {
      cerr << "Stack corrupted immediately.\n";
      cerr << (int)(data[i]) << " " << mv << "\n";
      exit(1);
    }
  }

  //cerr << "D: " << depth << "\n";
  if (depth < 0)
    return;

  for (int i=0; i<(MYRAND(3)+1); i++)
    messy2(t, td, depth-1, done);
  if ((depth == 0) && (!done) && (t))
  {
    (*t)(td);
    done = true;
  }
  for (int i=0; i<(MYRAND(3)+1); i++)
    messy2(t, td, depth-1, done);

  for (int i=0; i<ss; i++)
    if (data[i] != mv)
    {
      cerr << "Stack was corrupted.\n";
      cerr << (int)(data[i]) << " " << mv << "\n";
      exit(1);
    }
}

void messy(MessyFunc t, void *td = NULL)
{
  int depth = MYRAND(5)+6;
  bool done = false;

  if (use_messy)
    messy2(t, td, depth, done);
  else
  {
    if (t)
      (*t)(td);
  }
}

int main(int argc, char *argv[])
{
  vector <string> arg;
  for (int i=1; i<argc; i++)
    arg.push_back(string(argv[i]));

  while (arg.size() > 0)
  {
    if (arg[0] == "-h")
    {
      cerr << "Usage: foo [ops]\n";
      cerr << "   -h - Help.\n";
      cerr << "   -s - Use simple mode instead.\n";
      cerr << "   -c - Disable call of garbage collector.\n";
      cerr << "   -b - Disable use of ruby.\n";
      cerr << "   -z - Use zeroes instead of random values on stack.\n";
      cerr << "   -l - Use large stack size rather than random stack size.\n";
      cerr << "   -v - Be verbose.\n";
      exit(1);
    }
    else if (arg[0] == "-s")
    {
      use_messy = false;
      arg.erase(arg.begin());
    }
    else if (arg[0] == "-b")
    {
      use_ruby = false;
      arg.erase(arg.begin());
    }
    else if (arg[0] == "-z")
    {
      use_rand_vals = false;
      arg.erase(arg.begin());
    }
    else if (arg[0] == "-v")
    {
      verbose = true;
      arg.erase(arg.begin());
    }
    else if (arg[0] == "-l")
    {
      use_rand_stack_size = false;
      arg.erase(arg.begin());
    }
    else if (arg[0] == "-c")
    {
      use_gc = false;
      arg.erase(arg.begin());
    }
    else
    {
      cerr << "Bad arg.\n";
      exit(1);
    }
  }

  cerr << "Messy " << (use_messy ? "enabled" : "disabled")
       << ". Ruby " << (use_ruby ? "enabled" : "disabled")
       << ". Verbose " << (verbose ? "enabled" : "disabled")
       << ". GC " << (use_gc ? "enabled" : "disabled")
       << ".\nRand vals " << (use_rand_vals ? "enabled" : "disabled")
       << ". Rand stack size " << (use_rand_stack_size ? "enabled" : "disabled")
       << ".\n";

  cerr << "Empty test...\n";
  messy(Nothing);

  // Initialise.
  cerr << "Initialising...\n";
  if (use_ruby)
  {
    messy(InitRuby);
    messy(RubySafeGCZ);
    messy(InitRuby2);
    messy(RubySafeGCZ);
    messy(InitRuby3);
    messy(RubySafeGCZ);
    messy(InitRuby4);
    messy(RubySafeGCZ);
  }

  // Test over and over.
  cerr << "Thrashing...\n";
  for (int i=0; i<10000000; i++)
  {
    if (use_ruby)
    {
      cerr << i << ": " << " 1"; cerr.flush();
      messy(RubySafeGCZ);
      cerr << "2"; cerr.flush();
      messy(update2, &i);
      cerr << "3"; cerr.flush();
      messy(RubySafeGCZ);
      cerr << "4\n"; cerr.flush();
    }
    else
      messy(nonruby2, &i);
  }

  // Clean up.
  cerr << "Done thrashing.\n";
  if (use_ruby)
  {
    messy(RubySafeGCZ);
  }

  cerr << "Everything was okay.\n";
}
