require 'rubygems'
require 'webrick'
require 'rubygems/remote_fetcher'
require 'rubygems/format'

  SERVER_DATA = <<-EOY
--- !ruby/object:Gem::Cache
gems:
  rake-0.4.11: !ruby/object:Gem::Specification
    rubygems_version: "0.7"
    specification_version: 1
    name: rake
    version: !ruby/object:Gem::Version
      version: 0.4.11
    date: 2004-11-12
    summary: Ruby based make-like utility.
    require_paths:
      - lib
    author: Jim Weirich
    email: jim@weirichhouse.org
    homepage: http://rake.rubyforge.org
    rubyforge_project: rake
    description: Rake is a Make-like program implemented in Ruby. Tasks and dependencies are specified in standard Ruby syntax.
    autorequire:
    default_executable: rake
    bindir: bin
    has_rdoc: true
    required_ruby_version: !ruby/object:Gem::Version::Requirement
      requirements:
        -
          - ">"
          - !ruby/object:Gem::Version
            version: 0.0.0
      version:
    platform: ruby
    files:
      - README
    test_files: []
    library_stubs:
    rdoc_options:
    extra_rdoc_files:
    executables:
      - rake
    extensions: []
    requirements: []
    dependencies: []
EOY

PROXY_DATA = SERVER_DATA.gsub(/0.4.11/, '0.4.2')

PROXY_PORT = 1234
SERVER_PORT = 1345

def start_servers
  @normal_server ||= start_server(SERVER_PORT, SERVER_DATA)
  @proxy_server  ||= start_server(PROXY_PORT, PROXY_DATA)
  @enable_yaml = true
  @enable_zip = false
end

def start_server(port, data)
  Thread.new do
    s = WEBrick::HTTPServer.new(
      :Port            => port,
      :DocumentRoot    => nil,
      )
    
    s.start
  end
end

def setup
  start_servers
  enable_yaml = true
  enable_zip = false
  
  ENV.delete 'http_proxy'
  ENV.delete 'HTTP_PROXY'
  ENV.delete 'http_proxy_user'
  ENV.delete 'HTTP_PROXY_USER'
  ENV.delete 'http_proxy_pass'
  ENV.delete 'HTTP_PROXY_PASS'

  base_server_uri = "http://localhost:#{SERVER_PORT}"
  @proxy_uri = "http://localhost:#{PROXY_PORT}"
  @server_uri = base_server_uri + "/yaml"
 
  @fetcher = Gem::RemoteFetcher.fetcher
end

class Module
  def extend_object
    p 'extend_object'
  end
end

class IO
  remove_const(:WaitReadable)
end

setup

ENV['http_proxy'] = @proxy_uri
ENV['http_proxy_user'] = 'foo'
ENV['http_proxy_pass'] = 'bar'
fetcher = Gem::RemoteFetcher.new nil
p fetcher.fetch_path(@server_uri)

