require 'net/http'
require 'net/https'
require 'socket'

port = 6666

# listen for connections... but deliberately do not complete SSL handshake
server = TCPServer.open(port)

http = Net::HTTP.new('127.0.0.1', port)
http.use_ssl = true
http.read_timeout = 5
http.open_timeout = 5

req = Net::HTTP::Get.new('/')

puts "Start: #{Time.now.to_s}"
http.start { |http| http.request(req) }
# proper behavior is to throw a Timeout exception here after 5 seconds, since the 
# server will never respond to the SSL handshake
